/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.api.lifecycle;

import java.util.LinkedHashMap;
import java.util.TreeMap;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.AnimationType;
import lib.toma.animations.api.event.AnimationEventType;
import lib.toma.animations.api.lifecycle.IRegistry;
import lib.toma.animations.engine.Registry;
import lib.toma.animations.engine.screen.animator.Animator;
import net.minecraft.util.ResourceLocation;

public class Registries {
    public static final IRegistry<AnimationType<?>> ANIMATION_TYPES = new Registry.RegistryBuilder().map(new TreeMap(ResourceLocation::compareNamespaced)).vanillaListener(Registries::registerAnimationTypes).buildRegistry();
    public static final IRegistry<AnimationStage> ANIMATION_STAGES = new Registry.RegistryBuilder().map(new LinkedHashMap()).vanillaListener(devMode -> Registries.registerAnimationStages()).buildRegistry();
    public static final IRegistry<AnimationEventType<?>> EVENTS = new Registry.RegistryBuilder().map(new TreeMap(ResourceLocation::compareNamespaced)).vanillaListener(devMode -> Registries.registerEvents()).buildRegistry();

    private static AnimationType<?>[] registerAnimationTypes(boolean devMode) {
        if (devMode) {
            return new AnimationType[]{Animator.ANIMATOR_TYPE};
        }
        return new AnimationType[0];
    }

    private static AnimationStage[] registerAnimationStages() {
        return new AnimationStage[]{AnimationStage.HELD_ITEM, AnimationStage.RIGHT_HAND, AnimationStage.LEFT_HAND, AnimationStage.HANDS, AnimationStage.ITEM_AND_HANDS};
    }

    private static AnimationEventType<?>[] registerEvents() {
        return new AnimationEventType[]{AnimationEventType.SOUND, AnimationEventType.PLAY_ANIMATION, AnimationEventType.STOP_ANIMATION};
    }
}

